'Rookey Decoder: "Rdecode"
'G.Heron N2APB 
'rev 1.2 PRODUCTION 01/30/07
'Winning Tx Acquire Sequence hard-coded as 2-1-3"
	
symbol led1 = 4
symbol led2 = 2
symbol led3 = 1
symbol led4 = 0
symbol signal = pin3
symbol down = 0
symbol up = 1

symbol WS0 = bit0
symbol WS1 = bit1
symbol WS2 = bit2


symbol StartCntr = b4

symbol TXnr1 = bit7		'memory bits indicate which transmitter has already been received
symbol TXnr2 = bit6
symbol TXnr3 = bit5

symbol TX0 = bit8			;memory bits for TX code bits received
symbol TX1 = bit9

symbol TXcntr = b3


'*********************************************************
'                  START OF PROGRAM
'*********************************************************

         'Read the input Signal 
	  '... if high, then we're in normal Run mode
	  '... if low, then we're in Test mode
Start:
      if signal = up then Decode		'if input not grounded, then we're in normal Run mode
	sound 0, (116,5)                    'else we're in Test mode so output continuous tone
	goto Start

Decode:
	high led4					'turn off all LEDs at start
	high led3
	high led2
	high led1

loop:	StartCntr = 0

	   'Need 5 consecutive 50ms periods of '1' to detect START bit
	   '(Don't forget we're reading inverted from what spec waveform looks like!)

x1:	if signal = up then loop	
	StartCntr = StartCntr +1
	if StartCntr = 5 then x2
	pause 50
	goto x1

         'Wait for low-going edge of START bit

x2:	if signal = down then x2		

	  'Wait past the 50ms delimeter

	pause 50					

	   '-------------------------------------------------------
	   'Read three Win Sequence bits into bits WS0, WS1 and WS2
	   '-------------------------------------------------------

      pause 25					'move out to middle of WS0 bit
	WS0 = signal
 	pause 50					'move out to middle of WS1 bit
	WS1 = signal
 	pause 50					'move out to middle of WS2 bit
	WS2 = signal

	   ;------------------------------------------------------
	   ;Read two Tx bits and set LEDs & TXseq bits accordingly
	   ;------------------------------------------------------

n8:   pause 50
	if signal = 1 then x3
	TX0 = 1					'TX0 = 1
	goto x4
x3:	TX0 = 0					'TX0 = 0

x4:	pause 50
	if signal = 1 then x5
	TX1 = 1					'TX1 = 1
	goto x5a
x5:	TX1 = 0					'TX1 = 0

x5a:  b5 = b1					'test b1 but don't destroy it
	b5 = b5 & $03				'(so use b5)
	branch b5,(loop,xLED1,xLED2,xLED3)	'branch to the TX code detected

	   ;---------
	   ;TX1 Found

xLED1:
	if TXnr1 = 1 then loop			'don't do this logic if TX1 previously found
	TXnr1 = 1					'set memory bit so we can tell that we found TX1 already
	low LED1					'turn on LED1
	TXcntr = TXcntr + 1			'bump counter since we found a new TX
	branch TXcntr,(ckdone,x1a,x1b,x1c)	'first, second or third TX found?
x1a:	bit15 = 0					'first one, so set TX1 code in bit15 & bit 14
	bit14 = 1
	goto ckdone
x1b:	bit13 = 0					;second one, so set TX1 code in bit13 & bit12
	bit12 = 1
	goto ckdone
x1c:	bit11 = 0					'third one, so set TX1 code in bit 11 & bit10
	bit10 = 1
	goto ckdone

	   ;---------
	   ;TX2 Found
xLED2:
	if TXnr2 = 1 then loop			'don't do this one if TX2 previously found
	TXnr2 = 1					'set memory bit so we can tell that we found TX2 already
	low LED2					'turn on LED2
	TXcntr = TXcntr + 1			'bump counter since we found a new TX
	branch TXcntr,(ckdone,x2a,x2b,x2c)	'first, second or third TX found?
x2a:	bit15 = 1					'first one, so set TX2 code in bit15 & bit 14
	bit14 = 0
	goto ckdone
x2b:	bit13 = 1					;second one, so set TX2 code in bit13 & bit12
	bit12 = 0
	goto ckdone
x2c:	bit11 = 1					'third one, so set TX2 code in bit 11 & bit10
	bit10 = 0
	goto ckdone

	   ;---------
	   ;TX3 Found

xLED3:
	if TXnr3 = 1 then loop			'don't do this one if TX3 previously found
	TXnr3 = 1					'set memory bit so we can tell that we found TX3 already
	low LED3					'turn on LED3
	TXcntr = TXcntr + 1			'bump counter since we found a new TX
	branch TXcntr,(ckdone,x3a,x3b,x3c)	'first, second or third TX found?
x3a:	bit15 = 1					'first one, so set TX3 code in bit15 & bit 14
	bit14 = 1
	goto ckdone
x3b:	bit13 = 1					;second one, so set TX3 code in bit13 & bit12
	bit12 = 1
	goto ckdone
x3c:	bit11 = 1					'third one, so set TX3 code in bit 11 & bit10
	bit10 = 1

ckdone:
	if TXcntr < 3 then loop			'if we haven't yet acquired all 3 TXs, then keep trying

	   ;----------------------------
	   ;All three transmitters found
	   ;Check to see if they were found in the correct order
	
ckwin:
	b1 = b1 & $FC				'strip off lower two unused bits
here:	if b1 <> $9C then here		 	'if not winning sequence 2-1-3 (100111xx) then freeze

	   ;-------------
	   ;Winner found!
	   ;-------------

winner:
	pause 500

win:	high led4					'turn off all LEDs
	high led3
	high led2
	high led1

	low led1					'now produce continuous ring loop of LED lights
	pause 200
	high led1
	low led2
	pause 200
	high led2
	low led3
	pause 200
	high led3
	low led4
	pause 200
	goto win









